# HackyChat Privacy Policy

**Last Updated: November 2, 2025**

## Overview

HackyChat ("we", "us", or "our") is committed to protecting your privacy. This Privacy Policy explains how we collect, use, and safeguard your information when you use our browser extension.

## Information We Collect

### Anonymous Usage Data
- **Anonymous User Creation**: We create temporary anonymous user accounts for chat functionality
- **Chat Messages**: Text content you send in chat rooms
- **Page URLs**: URLs of pages where you use the extension (to find relevant chat rooms)
- **Basic Analytics**: Extension usage patterns (no personally identifiable information)

### Technical Data
- **Browser Information**: Basic browser type and version for compatibility
- **Extension Usage**: When and how you interact with the extension
- **Device Signals**: User agent, language, client hints, ASN, coarse geo, and hashed IP for abuse prevention

## How We Use Your Information

### Core Functionality
- Enable real-time chat in relevant online discussions
- Match you with existing chat rooms based on the content you're viewing
- Maintain chat room membership and message history

### Service Improvement
- Improve extension performance and user experience
- Debug technical issues
- Prevent abuse, ban evasion, and maintain service quality

## Data Storage and Security

### Server Location
- All data is stored on secure servers in the United States
- We use industry-standard encryption for data in transit and at rest

### Data Retention
- **Anonymous Users**: Data is retained for service functionality and may be deleted after periods of inactivity
- **Messages**: Stored indefinitely as part of the chat service unless deleted by users
- **Technical Logs**: Retained for debugging purposes, typically 30-90 days

## Data Sharing

We do **NOT** share, sell, or rent your personal information to third parties, except:

- **Service Providers**: Trusted third-party services that help us operate (hosting, databases)
- **Legal Requirements**: When required by law or to protect our rights

## Admin Access

Telemetry data is restricted to authorized administrators and is not visible to other users.

## Security Disclosure

We use device and network signals to enforce community safety rules. The exact detection methods are not publicly disclosed to prevent abuse.

## Your Rights

### Data Control
- **Message Deletion**: You can delete your own messages within chat rooms
- **Account Deletion**: Contact us to delete your anonymous account and associated data
- **Opt-out**: You can opt out of telemetry collection in extension settings

Opt-out applies to telemetry storage, but minimal safety checks may still occur to protect the platform.

### Data Access
- **Message History**: You can view your chat history within the extension
- **Data Requests**: Contact us for information about your data

## Cookies and Local Storage

The extension uses:
- **Local Storage**: To store your anonymous user token and preferences
- **No Cookies**: We do not use cookies in the traditional web sense

## Third-Party Services

We integrate with:
- **Render.com**: For hosting our chat service
- **Cloudflare**: For CDN and security services

Each service has its own privacy policy that applies to their handling of your data.

## Children's Privacy

Our service is not intended for children under 13. We do not knowingly collect personal information from children under 13.

## Changes to This Policy

We may update this Privacy Policy from time to time. We will notify users of significant changes through:
- Extension updates
- Our website
- In-app notifications

## Contact Us

For privacy-related questions or requests:
- **Email**: privacy@hackychat.com
- **Website**: https://hackychat.com/privacy

## Compliance

This extension complies with:
- **Chrome Web Store Developer Program Policies**
- **Firefox Add-on Distribution Agreement**
- **General Data Protection Regulation (GDPR)** where applicable
- **California Consumer Privacy Act (CCPA)** where applicable
