# HackyChat Browser Extension

A browser extension that lets users join conversations about the web content they're viewing.

## Features

- 🗨️ **Real-time chat** in topic-specific rooms
- 🔍 **Automatic room discovery** based on page content
- 👤 **Anonymous participation** with optional account creation
- 🗑️ **Message management** - delete your own messages
- 🌐 **Cross-browser support** - Chrome and Firefox
- 🔄 **Auto-updates** when published to official stores

## Browser Support

- **Chrome/Edge**: Manifest V3 compatible
- **Firefox**: Add-on compatible

## Installation

### Development (Unpacked)
1. Clone the repository
2. Open browser extension settings
3. Enable "Developer mode"
4. Click "Load unpacked" and select the `backend/extension/` folder

### Beta Download (ZIP)
1. Download https://hackychat.com/extension-beta.zip
2. Unzip and select the `extension` folder when loading unpacked
3. **Maintainer note:** Rebuild `landing-page/extension-beta.zip` whenever extension files change

### Official Stores (Recommended for users)
- **Chrome Web Store**: [Coming Soon]
- **Firefox Add-ons**: [Coming Soon]

## Permissions & Security

### Required Permissions

| Permission | Purpose | Justification |
|------------|---------|---------------|
| `activeTab` | Access current tab information | Needed to identify which page you're viewing for room matching |
| `storage` | Store user preferences and tokens | Required for maintaining anonymous user sessions |
| `sidePanel` | Display chat interface | Core functionality - shows the chat panel |
| `host_permissions` | API communication | Communicate with HackyChat servers for chat functionality |

### Host Permissions
- `https://hackychat-api.onrender.com/*` - API server for chat functionality
- `https://hackychat-web.onrender.com/*` - Web interface access

### Privacy & Security
- ✅ **Anonymous by default** - no personal information required
- ✅ **Limited telemetry** - basic device/network signals for abuse prevention
- ✅ **Opt-out available** - toggle in extension settings
- ✅ **Encrypted communications** - HTTPS only
- ✅ **CSP compliant** - Content Security Policy enforced
- ✅ **No third-party tracking** - No analytics or advertising

## Publishing to Browser Stores

### Prerequisites

Before publishing, ensure you have:

1. **Privacy Policy** ✅ (See `PRIVACY_POLICY.md`)
2. **Terms of Service** ✅ (See `TERMS_OF_SERVICE.md`)
3. **Store Screenshots** (1280x800 recommended):
   - Extension popup
   - Side panel chat interface
   - Room discovery
4. **Icon Assets** ✅ (All required sizes present)
5. **Developer Account**:
   - Chrome Web Store: $5 one-time fee
   - Firefox Add-ons: Free

### Chrome Web Store Publishing

1. **Create Developer Account**
   - Visit [Chrome Web Store Developer](https://chrome.google.com/webstore/developer/dashboard)
   - Pay $5 registration fee
   - Verify account

2. **Prepare Extension Package**
   ```bash
   # Create ZIP file (exclude development files)
   cd backend/extension
   zip -r mazzaChat-extension.zip . \
     -x "*.git*" "*.DS_Store" "*node_modules*" "*README.dev.md"
   ```

3. **Upload to Store**
   - Go to Developer Dashboard → "Add new item"
   - Upload `mazzaChat-extension.zip`
   - Fill out store listing:
     - **Title**: HackyChat
     - **Description**: Join conversations about the stories you're reading
     - **Category**: Social & Communication
     - **Screenshots**: 3-5 images showing functionality

4. **Store Listing Details**
   - **Short Description**: Real-time chat for web content
   - **Detailed Description**: See below
   - **Privacy Policy URL**: https://hackychat.com/privacy
   - **Support Website**: https://hackychat.com

### Firefox Add-ons Publishing

1. **Create Developer Account**
   - Visit [Firefox Add-ons](https://addons.mozilla.org/developers/)
   - Free registration
   - Verify email

2. **Upload Extension**
   - Use same ZIP file as Chrome
   - Firefox automatically converts Manifest V3
   - Fill out similar listing details

### Store Description

**Detailed Description:**
```
HackyChat brings conversations to your browsing experience. When you visit a website, HackyChat automatically finds or creates chat rooms where people are discussing that content.

🎯 Key Features:
• Real-time chat rooms for any webpage
• Anonymous participation
• Automatic room discovery
• Message deletion capabilities
• Cross-browser compatibility

🔒 Privacy First:
• No personal information required
• Anonymous by default
• Secure encrypted connections
• Transparent data practices

Perfect for:
• News article discussions
• Blog post conversations
• Documentation feedback
• Community-driven content analysis

Join the conversation about what you're reading!
```

### Post-Publishing

1. **Auto-Updates**
   - Upload new versions to stores
   - Users get automatic updates
   - No manual installation required

2. **Version Management**
   - Update `manifest.json` version number
   - Test thoroughly before publishing
   - Keep changelog for users

3. **Store Analytics**
   - Monitor installation numbers
   - Track user reviews and ratings
   - Respond to support requests

## Development

### Project Structure
```
backend/extension/
├── manifest.json          # Extension manifest
├── popup.html/js          # Extension popup interface
├── sidepanel.html/js      # Main chat interface
├── content-script.js      # Page injection logic
├── background.js          # Background service worker
├── icons/                 # Extension icons
├── PRIVACY_POLICY.md      # Privacy policy
├── TERMS_OF_SERVICE.md    # Terms of service
└── README.md             # This file
```

### Building for Production
```bash
# Ensure all files are ready
cd backend/extension

# Test extension functionality
# - Load as unpacked extension
# - Test all features
# - Verify permissions work correctly

# Create production ZIP
zip -r mazzaChat-v1.1.0.zip . \
  -x "*.git*" "*.DS_Store" "*node_modules*" "*README.dev.md"
```

## Support

- **Issues**: [GitHub Issues](https://github.com/your-repo/issues)
- **Email**: support@hackychat.com
- **Website**: https://hackychat.com/support

## License

See main project LICENSE file.

---

**Ready to publish?** Follow the steps above to get HackyChat in the official browser extension stores!
