// Extension configuration for different environments
const config = {
  development: {
    apiUrl: 'http://localhost:3000/api/v1',
    wsUrl: 'ws://localhost:3000/cable',
    frontendUrl: 'http://localhost:5173'
  },
  production: {
    apiUrl: 'https://api.hackychat.com/api/v1',
    wsUrl: 'wss://api.hackychat.com/cable',
    frontendUrl: 'https://hacky.chat'
  }
}

// Get current environment
// For now, default to production since we want to test the deployed app
function getEnvironment() {
  // Check if chrome.runtime.getManifest() indicates update_url (production)
  // or if it's loaded unpacked (development)
  try {
    const manifest = chrome.runtime.getManifest();
    // If update_url exists, extension is from Chrome Web Store (production)
    // If not, it's loaded unpacked (development)
    const isProduction = manifest.update_url !== undefined;

    // For testing: force production mode to use deployed URLs
    // Change this to 'development' if you want to test locally
    const forceEnvironment = 'production'; // Change to 'development' for local testing

    return forceEnvironment;
  } catch (e) {
    // Fallback: default to production for deployed testing
    return 'production';
  }
}

const environment = getEnvironment();
const currentConfig = config[environment];

console.log('[HackyChat] Using environment:', environment);
console.log('[HackyChat] API URL:', currentConfig.apiUrl);

export default currentConfig;
